<?php

use Illuminate\Foundation\Console\ClosureCommand;
use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use App\Services\TelegramService;

Artisan::command('inspire', function () {
    /** @var ClosureCommand $this */
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

Artisan::command('telegram:webhook:set {--url=} {--secret=}', function () {
    /** @var ClosureCommand $this */
    $url = $this->option('url') ?: (rtrim(config('app.url'), '/') . '/telegram/webhook');
    $secret = $this->option('secret') ?: (config('services.telegram.webhook_secret') ?: env('TELEGRAM_WEBHOOK_SECRET'));

    $resp = app(TelegramService::class)->setWebhook($url, $secret);
    $this->info(json_encode($resp, JSON_PRETTY_PRINT));
})->purpose('Configure Telegram bot webhook for TAKS Delivery');
