@php
$pageConfigs = ['navbarType' => 'sticky', 'contentLayout' => 'wide'];
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Wallet')

@section('vendor-style')
@vite([
  'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss',
  'resources/assets/vendor/libs/select2/select2.scss',
  'resources/assets/vendor/libs/@form-validation/form-validation.scss'
])
@endsection

@section('vendor-script')
@vite([
  'resources/assets/vendor/libs/moment/moment.js',
  'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js',
  'resources/assets/vendor/libs/select2/select2.js',
  'resources/assets/vendor/libs/@form-validation/popular.js',
  'resources/assets/vendor/libs/@form-validation/bootstrap5.js',
  'resources/assets/vendor/libs/@form-validation/auto-focus.js',
  'resources/assets/vendor/libs/cleave-zen/cleave-zen.js'
])
@endsection

@section('page-script')
<script>
  document.addEventListener('DOMContentLoaded', () => {
    const txTable = document.querySelector('#wallet-tx-table');
    if (txTable && window.$ && $.fn.DataTable) {
      $('#wallet-tx-table').DataTable({
        order: [[4, 'desc']],
        pageLength: 10,
        language: { search: 'Buscar:' }
      });
    }

    const ordersTable = document.querySelector('#wallet-orders-table');
    if (ordersTable && window.$ && $.fn.DataTable) {
      $('#wallet-orders-table').DataTable({
        order: [[0, 'desc']],
        pageLength: 10,
        language: { search: 'Buscar:' }
      });
    }
  });
</script>
@endsection

@section('content')
<div class="row g-6 mb-6">
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Saldo</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">€{{ number_format($restaurant->wallet_balance ?? 0, 2) }}</h4>
            </div>
            <small class="mb-0">Disponible</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-primary">
              <i class="icon-base ti tabler-wallet icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Costo entrega</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">€{{ number_format($restaurant->delivery_fee ?? 0, 2) }}</h4>
            </div>
            <small class="mb-0">Por pedido</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-info">
              <i class="icon-base ti tabler-coin icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Movimientos</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">{{ $transactions->total() }}</h4>
            </div>
            <small class="mb-0">Registros</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-warning">
              <i class="icon-base ti tabler-arrows-left-right icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Pedidos</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">{{ $deliveries->count() }}</h4>
            </div>
            <small class="mb-0">Últimos 20</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-success">
              <i class="icon-base ti tabler-list-check icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="card mb-6">
  <div class="card-header border-bottom">
    <h5 class="card-title mb-0">Movimientos</h5>
  </div>
  <div class="card-datatable table-responsive">
    <table class="table" id="wallet-tx-table">
      <thead class="border-top">
        <tr>
          <th>Tipo</th>
          <th>Monto</th>
          <th>Saldo</th>
          <th>Descripción</th>
          <th>Fecha</th>
        </tr>
      </thead>
      <tbody>
        @forelse ($transactions as $tx)
          <tr>
            <td>{{ $tx->type }}</td>
            <td>€{{ number_format($tx->amount, 2) }}</td>
            <td>€{{ number_format($tx->balance_after, 2) }}</td>
            <td>{{ $tx->description ?? '-' }}</td>
            <td>{{ $tx->created_at->format('d/m/Y H:i') }}</td>
          </tr>
        @empty
          <tr>
            <td colspan="5" class="text-center py-3">Sin movimientos.</td>
          </tr>
        @endforelse
      </tbody>
    </table>
  </div>
</div>

<div class="card">
  <div class="card-header border-bottom">
    <h5 class="card-title mb-0">Pago de pedidos</h5>
  </div>
  <div class="card-datatable table-responsive">
    <table class="table" id="wallet-orders-table">
      <thead class="border-top">
        <tr>
          <th>#</th>
          <th>Cliente</th>
          <th>Método</th>
          <th>Costo</th>
          <th>Estado</th>
          <th>Fecha</th>
        </tr>
      </thead>
      <tbody>
        @forelse ($deliveries as $delivery)
          <tr>
            <td>#{{ $delivery->id }}</td>
            <td>{{ $delivery->customer_name }}</td>
            <td>{{ $delivery->payment_method === 'cash' ? 'Efectivo' : 'Wallet' }}</td>
            <td>€{{ number_format($delivery->delivery_fee, 2) }}</td>
            <td>{{ ucfirst($delivery->status) }}</td>
            <td>{{ $delivery->created_at->format('d/m/Y H:i') }}</td>
          </tr>
        @empty
          <tr>
            <td colspan="6" class="text-center py-3">Sin pedidos todavía.</td>
          </tr>
        @endforelse
      </tbody>
    </table>
  </div>
</div>

@endsection
