@php
$pageConfigs = ['navbarType' => 'hidden', 'contentLayout' => 'wide'];
$configData = Helper::appClasses();
  $courier = $user->courier;
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Perfil repartidor')

@section('content')
<div class="courier-profile">
  <div class="profile-hero">
    <div class="profile-avatar">
      <span>{{ strtoupper(substr($user->name ?? 'R', 0, 1)) }}</span>
    </div>
    <div class="profile-info">
      <h4 class="mb-1">{{ $user->name ?? 'Repartidor' }}</h4>
      <div class="text-muted small">Panel de repartidor</div>
    </div>
    <div class="profile-status">
      @if (!$courier || !$courier->is_active)
        <span class="badge bg-label-danger">Desactivado</span>
      @elseif ($courier->is_online)
        <span class="badge bg-label-success">En línea</span>
      @else
        <span class="badge bg-label-secondary">Desconectado</span>
      @endif
    </div>
  </div>

  @if (session('success'))
    <div class="alert alert-success mt-3">{{ session('success') }}</div>
  @endif

  <div class="profile-metrics">
    <div class="metric-card">
      <div class="metric-icon bg-label-primary text-primary">
        <i class="icon-base ti tabler-wallet"></i>
      </div>
      <div>
        <div class="text-muted small">Saldo disponible</div>
        <div class="metric-value">€{{ number_format($user->courier?->wallet_balance ?? 0, 2) }}</div>
      </div>
    </div>
    <div class="metric-card">
      <div class="metric-icon bg-label-secondary text-secondary">
        <i class="icon-base ti tabler-cash"></i>
      </div>
      <div>
        <div class="text-muted small">Retirado</div>
        <div class="metric-value">€{{ number_format($user->courier?->wallet_withdrawn ?? 0, 2) }}</div>
      </div>
    </div>
  </div>

  <div class="card profile-card">
    <div class="card-body">
      <h5 class="mb-3">Estado de disponibilidad</h5>
      <form method="POST" action="{{ route('courier.status.update') }}" class="status-form">
        @csrf
        <input type="hidden" name="is_online" value="0">
        <label class="status-toggle">
          <input type="checkbox" name="is_online" value="1" @checked($courier?->is_online) @disabled(!$courier || !$courier->is_active)>
          <span class="status-track">
            <span class="status-thumb"></span>
          </span>
          <span class="status-label">
            {{ ($courier && $courier->is_active) ? ($courier->is_online ? 'En línea' : 'Desconectado') : 'Desactivado' }}
          </span>
        </label>
        <small class="text-muted d-block mt-2">Solo recibes pedidos si estás en línea.</small>
      </form>
    </div>
  </div>

  <div class="card profile-card">
    <div class="card-body">
      <h5 class="mb-3">Preferencias</h5>
      <form method="POST" action="{{ route('courier.profile.update') }}">
        @csrf
        <div class="mb-3">
          <label class="form-label">App de navegación</label>
          <div class="segmented">
            <label class="segmented-item">
              <input type="radio" name="nav_app" value="maps" @checked($user->nav_app === 'maps')>
              <span><i class="icon-base ti tabler-map"></i> Google Maps</span>
            </label>
            <label class="segmented-item">
              <input type="radio" name="nav_app" value="waze" @checked($user->nav_app === 'waze')>
              <span><i class="icon-base ti tabler-navigation"></i> Waze</span>
            </label>
          </div>
        </div>
        <div class="mb-3">
          <label class="form-label">Máximo de pedidos activos</label>
          <select class="form-select" name="max_active_orders">
            @for ($i = 1; $i <= 10; $i++)
              <option value="{{ $i }}" @selected(($user->max_active_orders ?? 3) == $i)>{{ $i }}</option>
            @endfor
          </select>
          <small class="text-muted">Por defecto 3. Puedes subir hasta 10.</small>
        </div>
        <button class="btn btn-primary w-100" type="submit">Guardar cambios</button>
      </form>
    </div>
  </div>

  <div class="card profile-card">
    <div class="card-body">
      <h5 class="mb-3">Telegram</h5>
      <p class="text-muted mb-3">Recibe una alerta por Telegram cuando te asignen un nuevo pedido.</p>

      @php
        $bot = config('services.telegram.bot_username');
        $token = $user->telegram_connect_token;
        $connectUrl = $bot && $token ? ('https://t.me/' . $bot . '?start=' . $token) : null;
      @endphp

      @if ($user->telegram_chat_id)
        <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-3">
          <div>
            <div class="fw-semibold">Conectado</div>
            <div class="text-muted small">
              {{ $user->telegram_connected_at ? $user->telegram_connected_at->format('d/m/Y H:i') : '' }}
            </div>
          </div>
          <form method="POST" action="{{ route('courier.telegram.disconnect') }}">
            @csrf
            <button class="btn btn-outline-danger btn-sm" type="submit">
              <i class="icon-base ti tabler-unlink me-1"></i> Desconectar
            </button>
          </form>
        </div>
      @else
        <div class="alert alert-warning">
          No conectado. Pulsa el botón para abrir Telegram y vincular tu cuenta.
        </div>
      @endif

      @if ($connectUrl)
        <a class="btn btn-primary w-100" href="{{ $connectUrl }}" target="_blank" rel="noopener">
          <i class="icon-base ti tabler-brand-telegram me-1"></i> Conectar Telegram
        </a>
        <small class="text-muted d-block mt-2">
          Si no abre, busca el bot <strong>@{{ $bot }}</strong> y escribe <strong>/start</strong>.
        </small>
      @else
        <div class="alert alert-danger mb-0">
          Falta configurar <code>TELEGRAM_BOT_USERNAME</code> en el .env.
        </div>
      @endif
    </div>
  </div>

  <div class="card profile-card">
    <div class="card-body">
      <h5 class="mb-3">Sesión</h5>
      <form method="POST" action="{{ route('logout') }}">
        @csrf
        <button class="btn btn-label-danger w-100" type="submit">
          <i class="icon-base ti tabler-logout me-1"></i> Cerrar sesión
        </button>
      </form>
    </div>
  </div>
</div>

<nav class="courier-bottom-nav">
  <a href="{{ route('courier.dashboard') }}">
    <i class="icon-base ti tabler-map"></i>
  </a>
  <a href="{{ route('courier.orders.index') }}">
    <i class="icon-base ti tabler-clipboard-text"></i>
  </a>
  <a href="{{ route('courier.records.index') }}">
    <i class="icon-base ti tabler-history"></i>
  </a>
  <a class="active" href="{{ route('courier.profile.edit') }}">
    <i class="icon-base ti tabler-user"></i>
  </a>
</nav>
@endsection

@section('page-style')
  <style>
    .courier-profile {
      display: grid;
      gap: 16px;
    }
    .profile-hero {
      display: grid;
      grid-template-columns: auto 1fr auto;
      align-items: center;
      gap: 16px;
      background: linear-gradient(135deg, rgba(235, 61, 99, 0.12), rgba(255, 255, 255, 0));
      border: 1px solid rgba(15, 20, 34, 0.08);
      border-radius: 18px;
      padding: 16px 20px;
    }
    .profile-avatar {
      width: 54px;
      height: 54px;
      border-radius: 14px;
      background: #ffe6ec;
      color: #eb3d63;
      font-weight: 700;
      display: grid;
      place-items: center;
      font-size: 20px;
    }
    .profile-status {
      align-self: start;
    }
    .profile-metrics {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
      gap: 12px;
    }
    .metric-card {
      display: flex;
      align-items: center;
      gap: 12px;
      padding: 14px 16px;
      border-radius: 16px;
      background: #fff;
      border: 1px solid rgba(15, 20, 34, 0.08);
      box-shadow: 0 6px 18px rgba(15, 20, 34, 0.06);
    }
    .metric-icon {
      width: 42px;
      height: 42px;
      border-radius: 12px;
      display: grid;
      place-items: center;
      font-size: 18px;
    }
    .metric-value {
      font-weight: 700;
      font-size: 18px;
    }
    .profile-card {
      border-radius: 18px;
      border: 1px solid rgba(15, 20, 34, 0.08);
      box-shadow: 0 6px 18px rgba(15, 20, 34, 0.06);
    }
    .status-form {
      display: flex;
      flex-direction: column;
      gap: 8px;
    }
    .status-toggle {
      display: inline-flex;
      align-items: center;
      gap: 12px;
      cursor: pointer;
      font-weight: 600;
      color: #4b465c;
    }
    .status-toggle input {
      display: none;
    }
    .status-track {
      width: 46px;
      height: 26px;
      border-radius: 999px;
      background: #e2e8f0;
      position: relative;
      transition: background 0.2s ease;
    }
    .status-thumb {
      position: absolute;
      top: 3px;
      left: 3px;
      width: 20px;
      height: 20px;
      border-radius: 999px;
      background: #fff;
      box-shadow: 0 2px 6px rgba(15, 20, 34, 0.2);
      transition: transform 0.2s ease;
    }
    .status-toggle input:checked + .status-track {
      background: rgba(40, 199, 111, 0.35);
    }
    .status-toggle input:checked + .status-track .status-thumb {
      transform: translateX(20px);
    }
    .status-toggle input:disabled + .status-track {
      background: #f1f3f5;
    }
    .segmented {
      display: grid;
      grid-template-columns: repeat(2, minmax(0, 1fr));
      gap: 10px;
    }
    .segmented-item {
      border: 1px solid rgba(15, 20, 34, 0.12);
      border-radius: 12px;
      padding: 10px 12px;
      display: flex;
      align-items: center;
      gap: 8px;
      cursor: pointer;
      font-weight: 600;
      color: #4b465c;
      background: #fff;
    }
    .segmented-item input {
      display: none;
    }
    .segmented-item:has(input:checked) {
      border-color: rgba(235, 61, 99, 0.6);
      background: rgba(235, 61, 99, 0.08);
      color: #eb3d63;
    }
    .courier-bottom-nav {
      position: fixed;
      left: 0;
      right: 0;
      bottom: 0;
      background: #fff;
      border-top: 1px solid rgba(15, 20, 34, 0.08);
      display: grid;
      grid-template-columns: repeat(4, 1fr);
      padding: 8px 14px 12px;
      z-index: 20;
    }
    .courier-bottom-nav a {
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 2px;
      color: #6f6b7d;
      font-size: 12px;
      text-decoration: none;
    }
    .courier-bottom-nav a i {
      font-size: 20px;
    }
    .courier-bottom-nav a.active {
      color: #28c76f;
      font-weight: 600;
    }
    @media (max-width: 991px) {
      body {
        padding-bottom: 70px;
      }
      .profile-hero {
        grid-template-columns: auto 1fr;
      }
      .profile-status {
        grid-column: 1 / -1;
      }
      #layout-menu,
      .layout-navbar,
      .layout-menu-toggle,
      .content-footer {
        display: none !important;
      }
    }
  </style>
@endsection

@section('page-script')
  <script>
    document.querySelectorAll('.status-form input[type="checkbox"]').forEach((input) => {
      input.addEventListener('change', () => {
        input.closest('form').submit();
      });
    });
  </script>
@endsection
