@php
$pageConfigs = ['navbarType' => 'hidden', 'contentLayout' => 'wide'];
$configData = Helper::appClasses();
$statusMap = [
  'pending' => ['Pendiente', 'warning'],
  'confirmed' => ['Confirmado', 'info'],
  'at_restaurant' => ['En restaurante', 'primary'],
  'en_route' => ['En camino', 'primary'],
  'delivered' => ['Entregado', 'success'],
  'cancelled' => ['Cancelado', 'danger'],
];
[$statusLabel, $statusColor] = $statusMap[$delivery->status] ?? ['Pendiente', 'warning'];
$origin = $delivery->restaurant?->address ?? '';
$destination = $delivery->delivery_address ?? '';
$navApp = auth()->user()->nav_app ?? 'maps';
$navUrl = $navApp === 'waze'
  ? 'https://waze.com/ul?q=' . urlencode($destination) . '&navigate=yes'
  : 'https://www.google.com/maps/dir/?api=1&origin=' . urlencode($origin) . '&destination=' . urlencode($destination);
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Pedido')

@section('content')
<div class="courier-order-detail">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h4 class="mb-0">Pedido #{{ $delivery->id }}</h4>
    <div class="d-flex gap-2">
      <a class="btn btn-outline-secondary btn-sm" href="{{ $from === 'map' ? route('courier.dashboard') : route('courier.orders.index') }}">Volver</a>
      <a class="btn btn-outline-primary btn-sm" href="{{ route('courier.orders.index') }}">Pedidos entregados</a>
    </div>
  </div>

  <div class="card">
    <div class="card-body">
      <div class="d-flex align-items-center justify-content-between mb-2">
        <span class="badge bg-{{ $statusColor }}">{{ $statusLabel }}</span>
        <small class="text-muted">{{ $delivery->created_at->format('d/m/Y H:i') }}</small>
      </div>

      <div class="mb-3">
        <div class="fw-semibold">Cliente</div>
        <div>{{ $delivery->customer_name }}</div>
        <div class="text-muted">{{ $delivery->customer_phone ?? 'Sin teléfono' }}</div>
      </div>

      <div class="mb-3">
        <div class="fw-semibold">Recogida</div>
        <div class="text-muted">{{ $delivery->restaurant?->address ?? 'Restaurante' }}</div>
      </div>

      <div class="mb-3">
        <div class="fw-semibold">Entrega</div>
        <div class="text-muted">{{ $delivery->delivery_address }}</div>
        @if ($delivery->delivery_address_extra)
          <div class="text-muted">{{ $delivery->delivery_address_extra }}</div>
        @endif
      </div>

      @if ($delivery->notes)
        <div class="mb-3">
          <div class="fw-semibold">Notas</div>
          <div class="text-muted">{{ $delivery->notes }}</div>
        </div>
      @endif

      <div class="d-flex flex-wrap gap-2">
        <a class="btn btn-outline-primary" href="{{ $navUrl }}" target="_blank" rel="noopener">
          Abrir navegación
        </a>
        @if ($delivery->status === 'pending')
          <form method="POST" action="{{ route('courier.deliveries.status', $delivery) }}">
            @csrf
            <input type="hidden" name="status" value="confirmed" />
            <button class="btn btn-success" type="submit">Confirmar pedido</button>
          </form>
          <form method="POST" action="{{ route('courier.deliveries.reject', $delivery) }}">
            @csrf
            <input type="hidden" name="reason" value="Rechazado desde detalle" />
            <button class="btn btn-outline-danger" type="submit">Rechazar</button>
          </form>
        @elseif ($delivery->status === 'confirmed')
          <form method="POST" action="{{ route('courier.deliveries.status', $delivery) }}">
            @csrf
            <input type="hidden" name="status" value="at_restaurant" />
            <button class="btn btn-info" type="submit">He llegado al restaurante</button>
          </form>
        @elseif ($delivery->status === 'at_restaurant')
          <form method="POST" action="{{ route('courier.deliveries.status', $delivery) }}">
            @csrf
            <input type="hidden" name="status" value="en_route" />
            <button class="btn btn-warning" type="submit">Salir al cliente</button>
          </form>
        @elseif ($delivery->status === 'en_route')
          <form method="POST" action="{{ route('courier.deliveries.status', $delivery) }}">
            @csrf
            <input type="hidden" name="status" value="delivered" />
            <button class="btn btn-success" type="submit">Entregado</button>
          </form>
        @endif
      </div>
    </div>
  </div>
</div>
@endsection

@section('page-style')
  <style>
    .courier-order-detail {
      min-height: 100vh;
    }
    @media (max-width: 991px) {
      #layout-menu,
      .layout-navbar,
      .layout-menu-toggle,
      .content-footer {
        display: none !important;
      }
    }
  </style>
@endsection
