<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('deliveries', function (Blueprint $table) {
            $table->string('payment_method')->default('wallet')->after('delivery_fee');
            $table->boolean('is_urgent')->default(false)->after('payment_method');
            $table->timestamp('urgent_requested_at')->nullable()->after('is_urgent');
        });
    }

    public function down(): void
    {
        Schema::table('deliveries', function (Blueprint $table) {
            $table->dropColumn('payment_method');
        });
    }
};
