<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('couriers', function (Blueprint $table) {
            $table->decimal('wallet_balance', 10, 2)->default(0)->after('notes');
            $table->decimal('wallet_withdrawn', 10, 2)->default(0)->after('wallet_balance');
        });
    }

    public function down(): void
    {
        Schema::table('couriers', function (Blueprint $table) {
            $table->dropColumn(['wallet_balance', 'wallet_withdrawn']);
        });
    }
};
