<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('restaurants', function (Blueprint $table) {
            $table->decimal('wallet_balance', 10, 2)->default(0)->after('notes');
            $table->decimal('delivery_fee', 10, 2)->default(3)->after('wallet_balance');
        });
    }

    public function down(): void
    {
        Schema::table('restaurants', function (Blueprint $table) {
            $table->dropColumn(['wallet_balance', 'delivery_fee']);
        });
    }
};
