<?php

namespace App\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\ServiceProvider;

class MenuServiceProvider extends ServiceProvider
{
  /**
   * Register services.
   */
  public function register(): void
  {
    //
  }

  /**
   * Bootstrap services.
   */
  public function boot(): void
  {
    View::composer('*', function ($view) {
      $menuGroup = 'guest';
      $user = Auth::user();

      if ($user) {
        if ($user->role === 'restaurant') {
          $menuGroup = 'restaurant';
        } elseif ($user->role === 'courier') {
          $menuGroup = 'courier';
        } else {
          $menuGroup = $user->is_admin ? 'admin' : 'guest';
        }
      }

      $verticalMenuJson = file_get_contents(base_path("resources/menu/{$menuGroup}/verticalMenu.json"));
      $verticalMenuData = json_decode($verticalMenuJson);
      $horizontalMenuJson = file_get_contents(base_path("resources/menu/{$menuGroup}/horizontalMenu.json"));
      $horizontalMenuData = json_decode($horizontalMenuJson);

      $view->with('menuData', [$verticalMenuData, $horizontalMenuData]);
    });
  }
}
