<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Zone extends Model
{
    /** @use HasFactory<\Database\Factories\ZoneFactory> */
    use HasFactory;

    protected $fillable = [
        'name',
        'city',
        'description',
        'center_address',
        'center_lat',
        'center_lng',
        'radius_km',
        'is_active',
    ];

    public function restaurants()
    {
        return $this->hasMany(Restaurant::class);
    }

    public function couriers()
    {
        return $this->hasMany(Courier::class);
    }
}
