<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Delivery extends Model
{
    /** @use HasFactory<\Database\Factories\DeliveryFactory> */
    use HasFactory;

    public const STATUS_PENDING = 'pending';
    public const STATUS_CONFIRMED = 'confirmed';
    public const STATUS_AT_RESTAURANT = 'at_restaurant';
    public const STATUS_EN_ROUTE = 'en_route';
    public const STATUS_DELIVERED = 'delivered';
    public const STATUS_CANCELLED = 'cancelled';

    public const ACTIVE_STATUSES = [
        self::STATUS_PENDING,
        self::STATUS_CONFIRMED,
        self::STATUS_AT_RESTAURANT,
        self::STATUS_EN_ROUTE,
    ];

    protected $fillable = [
        'restaurant_id',
        'courier_id',
        'status',
        'assigned_at',
        'customer_name',
        'customer_phone',
        'delivery_address',
        'delivery_address_extra',
        'delivery_lat',
        'delivery_lng',
        'notes',
        'delivery_fee',
        'payment_method',
        'is_urgent',
        'urgent_requested_at',
        'push_attempt',
        'push_last_sent_at',
        'fee_transferred_at',
        'completed_at',
        'cancelled_at',
        'cancel_reason',
    ];

    protected $casts = [
        'assigned_at' => 'datetime',
        'urgent_requested_at' => 'datetime',
        'push_last_sent_at' => 'datetime',
        'fee_transferred_at' => 'datetime',
        'completed_at' => 'datetime',
        'cancelled_at' => 'datetime',
        'is_urgent' => 'boolean',
    ];

    public function restaurant()
    {
        return $this->belongsTo(Restaurant::class);
    }

    public function courier()
    {
        return $this->belongsTo(Courier::class);
    }

    public static function statusLabels(): array
    {
        return [
            self::STATUS_PENDING => ['Pendiente', 'warning'],
            self::STATUS_CONFIRMED => ['Confirmado', 'info'],
            self::STATUS_AT_RESTAURANT => ['En restaurante', 'primary'],
            self::STATUS_EN_ROUTE => ['En camino', 'primary'],
            self::STATUS_DELIVERED => ['Entregado', 'success'],
            self::STATUS_CANCELLED => ['Cancelado', 'danger'],
        ];
    }
}
