<?php

namespace App\Http\Responses;

use Illuminate\Http\Request;
use Laravel\Fortify\Contracts\LoginResponse as LoginResponseContract;

class LoginResponse implements LoginResponseContract
{
    /**
     * @param  \Illuminate\Http\Request  $request
     */
    public function toResponse($request)
    {
        $user = $request->user();

        if ($user?->role === 'restaurant') {
            return redirect()->route('restaurant.dashboard');
        }
        if ($user?->role === 'courier') {
            return redirect()->route('courier.dashboard');
        }

        return redirect()->route('admin.dashboard');
    }
}
