<?php

namespace App\Http\Controllers\Courier;

use App\Http\Controllers\Controller;
use App\Models\Delivery;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class OrdersController extends Controller
{
    public function index(Request $request)
    {
        $courier = $request->user()->courier;

        $query = Delivery::query();

        if ($courier) {
            $query->where('courier_id', $courier->id);
        } else {
            $query->whereRaw('1 = 0');
        }

        $deliveries = collect();

        $activeDeliveries = $courier
            ? Delivery::where('courier_id', $courier->id)
                ->whereIn('status', Delivery::ACTIVE_STATUSES)
                ->latest()
                ->get()
            : collect();

        return view('courier.orders.index', [
            'courier' => $courier,
            'deliveries' => $deliveries,
            'activeDeliveries' => $activeDeliveries,
            'filters' => $request->only(['date_from', 'date_to', 'status', 'phone', 'customer', 'day']),
            'days' => collect(),
            'selectedDay' => '',
        ]);
    }

    public function show(Request $request, Delivery $delivery)
    {
        $courierId = $request->user()->courier_id;

        if (!$courierId || $delivery->courier_id !== $courierId) {
            abort(403);
        }

        return view('courier.orders.show', [
            'delivery' => $delivery,
            'from' => $request->query('from'),
        ]);
    }
}
